# -*- coding: UTF-8 -*-
import json

from openpyxl import load_workbook
from django.core.management import BaseCommand

from api.models import Doctor


class Command(BaseCommand):
    def handle(self, *args, **kwargs):
        read_excel_file = u'/tmp/医生商务和商务组对应关系.xlsx'
        ws = load_workbook(read_excel_file).active
        doctor_data = {
            x.id: {'from': x.business_group}
            for x in Doctor.objects.all()
        }
        for r in ws.rows[1:]:
            doctor_id, group = r[0].value, r[2].value
            if not (doctor_id and group) or doctor_id not in doctor_data:
                continue
            doctor_data[doctor_id]['to'] = group
            Doctor.objects.filter(id=doctor_id).update(business_group=group)
        json.dump(doctor_data, open('doctor_business_group_change.json', 'w'))
