# coding=utf-8
from api.models import Coupon, CouponGift, CouponDistribute
from api.models import GiftChannelLaunch, ChannelGift, ChannelGiftUserRelation
from api.models import BusinessChannel
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_types.gaia import COUPON_GIFT_TYPES, COUPON_DISTRIBUTION_STATUS
from gm_types.doctor import COUPON_FILTER_STATUS
from gm_types.gaia import BENEFIT_TYPE
from datetime import datetime
from gm_dataquery.db import DB
from rpc.cache import coupon_cache


class CouponDB(DataBuilder):
    """
    coupon实体的返回数据格式
    """

    def getval_start_time(self, obj, default=''):
        if obj.start_time:
            return str(obj.start_time)[0:19]

    def getval_end_time(self, obj, default=''):
        if obj.end_time:
            return str(obj.end_time)[0:19]

    def getval_activated_time(self, obj, default=''):
        if obj.activated_time:
            return str(obj.activated_time)[0:19]
        else:
            return u''

    def getval_has_threshold(self, obj, default=''):
        return BENEFIT_TYPE.getDesc(obj.benefit_type)

    def getval_coupon_doctor(self, obj):
        return obj.doctor.name

    def getval_doctor_coupon_time(self, obj):
        gift = obj.doctor_coupon_gift()
        start_time = str(gift.start_time).split()[0]
        end_time = str(gift.end_time).split()[0]
        return u'{}至{}'.format(start_time, end_time)

    def getval_doctor_gift_status(self, obj):
        return COUPON_FILTER_STATUS.getDesc(obj.listitem_for_doctor()['filter_status'])

    def getval_effect_person_name(self, obj):
        return obj.effect_person.username

    def getval_is_effect(self, obj):
        return '是' if obj.activated_time else '否'

    def getval_cost_bear(self, obj, need_escape=True):
        return obj.cost_bear


@DB
class CouponDQ(DataSQLQuery):
    """
    coupon实体查询过滤
    """
    model = Coupon
    data_model = CouponDB

    def filter_activated_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_start_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_end_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)


class CouponGiftDB(DataBuilder):
    pass


@DB
class CouponGiftDQ(DataSQLQuery):
    model = CouponGift
    data_model = CouponGiftDB

    def filter_created_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_start_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_end_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)


class ChannelDB(DataBuilder):
    def getval_created_time(self, obj, default=''):
        if obj.created_time:
            return str(obj.created_time)[0:19]


@DB
class ChannelDQ(DataSQLQuery):
    model = BusinessChannel
    data_model = ChannelDB

    def filter_created_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)


class ChannelGiftDB(DataBuilder):
    def getval_gift_name(self, obj):
        return obj.gift.name

    def getval_gift_id(self, obj):
        return obj.gift.id

    def getval_left(self, obj):
        launchs = ChannelGiftUserRelation.objects.filter(channel_gift=obj)
        return obj.total - launchs.count()


@DB
class ChannelGiftDQ(DataSQLQuery):
    model = ChannelGift
    data_model = ChannelGiftDB
    pass


@DB
class CouponDistributeDQ(DataSQLQuery):
    model = CouponDistribute
    data_model = DataBuilder
