# coding=utf-8
from api.models import Coupon, CouponGift
from api.models import GiftChannelLaunch, ChannelGift, ChannelGiftUserRelation
from api.models import BusinessChannel
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_types.gaia import COUPON_GIFT_TYPES, COUPON_DISTRIBUTION_STATUS
from datetime import datetime
from api.models import CouponSKURestrict
from gm_dataquery.db import DB


class CouponSKUDB(DataBuilder):
    def getval_sku_name(self, obj):
        return ''.join(obj.sku.items_name)

    def getval_sku_gengmei_price(self, obj):
        return obj.sku.get_default_price_info()['gengmei_price']

    def getval_sku_pre_payment_price(self, obj):
        return obj.sku.get_default_price_info()['pre_payment_price']

    def getval_sku_hospital_payment_price(self, obj):
        return obj.sku.get_default_price_info()['gengmei_price'] - obj.sku.get_default_price_info()['pre_payment_price']


@DB
class CouponSKUDQ(DataSQLQuery):
    model = CouponSKURestrict
    data_model = CouponSKUDB


