# -*- coding: UTF-8 -*-

from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from hippo.models.record import PhoneRecord


class PhoneRecordDB(DataBuilder):
    def getval_user__last_name(self, obj):
        return obj.user.last_name if getattr(obj, 'user', None) else ''

    def getval_doctor__name(self, obj):
        return obj.doctor.name if getattr(obj, 'doctor', None) else ''


@DB
class PhoneRecordDQ(DataSQLQuery):
        model = PhoneRecord
        data_model = PhoneRecordDB
