# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import RecommendDoctor, StockAlert


class RecommendDoctorDB(DataBuilder):
    def getval_diary_info(self, obj):
        return {'id': obj.diary.id, 'title': obj.diary.title}

    def getval_person__user_id(self, obj):
        return obj.person.user.id

    def query_recommend_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)


@DB
class RecommendDoctorDQ(DataSQLQuery):
        model = RecommendDoctor
        data_model = RecommendDoctorDB


class StockAlertDB(DataBuilder):
    pass


@DB
class StockAlertDQ(DataSQLQuery):
    model = StockAlert
    data_model = StockAlertDB

    def filter_has_phone(self, srch_key, srch_val, regex=False):
        q = Q(phone__isnull=False)
        if srch_val == '1':
            return q
        else:
            return ~q

    def filter_has_service(self, srch_key, srch_val, regex=False):
        q = Q(diary__service__isnull=False)
        if srch_val == '1':
            return q
        else:
            return ~q
