# coding=utf-8

# -*- coding: UTF-8 -*-

from django.db.models import Q, Max, Min, Count
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB

from api.models import Service, ServiceRecommend


class ServiceRecommendDB(DataBuilder):
    """
    美购推荐返回数据格式
    """
    def getval_service__id(self, obj):
        return obj.service.id

    def getval_service__name(self, obj):
        return obj.service.name

    def getval_service__is_online(self, obj):
        if obj.service.is_online:
            return '是'
        else:
            return '否'

    def getval_pre_payment_price(self, obj):
        service = obj.service
        serviceitems_price_info = [x.get_default_price_info() for x in service.items.filter(is_delete=False)]

        serviceitems_price_info.sort(key=lambda x: x['pre_payment_price'])
        return serviceitems_price_info[0]['pre_payment_price']

    def getval_gengmei_price(self, obj):
        service = obj.service
        serviceitems_price_info = [x.get_default_price_info() for x in service.items.filter(is_delete=False)]

        serviceitems_price_info.sort(key=lambda x: x['pre_payment_price'])
        return serviceitems_price_info[0]['gengmei_price']

    def getval_discount(self, obj):
        service = obj.service
        serviceitems_price_info = [x.get_default_price_info() for x in service.items.filter(is_delete=False)]

        serviceitems_price_info.sort(key=lambda x: x['pre_payment_price'])
        return serviceitems_price_info[0]['gengmei_price']


@DB
class ServiceRecommendDQ(DataSQLQuery):
    """
    美购推荐查询格式
    """
    model = ServiceRecommend
    data_model = ServiceRecommendDB
