# -*- coding: UTF-8 -*-
from __future__ import unicode_literals
import json
from django.db.models import Q, F
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery

from api.models import CashBackOrder, Doctor, Hospital, RefundOrder
from gm_types.gaia import NEW_CASH_BACK_STATUS, PAYMENT_CHANNEL, REFUND_STATUS


class StaleRefundOrderDB(DataBuilder):
    def getval_status(self, obj):
        return REFUND_STATUS.getDesc(obj.status)

    def getval_order__payment_channel(self, obj):
        return PAYMENT_CHANNEL.getDesc(obj.order.payment_channel)


class StaleRefundOrderDQ(DataSQLQuery):
    model = RefundOrder
    data_model = StaleRefundOrderDB

    def filter_created_at(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_refunded_at(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_payment_channel(self, srch_key, srch_val, regex=False):
        return Q(order__payment_channel=srch_val)
