# -*- coding: UTF-8 -*-
from django.conf import settings
from rpc.decorators import bind_context
from .models import *
from .tasks import handle_viewmodel_sync


@bind_context('hera/viewmodel/sync')
def recieve_viewmodel_signal(ctx, viewmodel, ids):
    # print __import__('sys')._getframe().f_code.co_name, viewmodel, ids
    vm_cls = globals().get(viewmodel)
    if settings.DEBUG and not settings.ASYNC_TRIGGER_RECIEVE:
        handle_viewmodel_sync(vm_cls, ids)
    else:
        handle_viewmodel_sync.delay(vm_cls, ids)
