# coding=utf-8
# create by oldman at 2018/4/17
from django.conf import settings
from django.db import models
from gm_types.doctor import DATE_TYPE
from .doctor import Doctor
from .merchant import Merchant


class MerchantStatDailyData(models.Model):
    class Meta:
        verbose_name = '商户每日统计数据(商户表存在整形表中)'
        db_table = 'hippo_merchant_stat_updates'

    date = models.DateField('统计日期')
    merchant_id = models.BigIntegerField('商家ID')

    service_pv = models.BigIntegerField('美购详情页PV', default=0)
    home_pv = models.BigIntegerField('医生主页PV+医院主页PV', default=0)
    diary_pv = models.BigIntegerField('日记本详情页PV+日记帖详情页PV', default=0)

    ad_recharge = models.BigIntegerField('广告充值金额', default=0)
    ad_consume = models.BigIntegerField('广告消耗金额', default=0)
    offline_amount = models.BigIntegerField('财务确认的线下打款金额', default=0)

    validated_price = models.BigIntegerField('验证订单总价（更美价)', default=0)
    validated_discount = models.BigIntegerField('验证订单抽成', default=0)
    validated_price_user = models.BigIntegerField('纯用户验证订单总价（更美价）', default=0)
    rate = models.FloatField(verbose_name=u'乘的系数', default=1)


class BusinessData(models.Model):
    class Meta:
        verbose_name = u'医生经营数据'
        db_table = 'hippo_business_data'
        app_label = 'hippo'

    merchant = models.ForeignKey(Merchant, verbose_name=u'商户')
    doctor = models.ForeignKey(Doctor, verbose_name=u'医生')
    new_diary = models.IntegerField(verbose_name=u'新增日记本', default=0)
    five_stars_diary = models.IntegerField(verbose_name=u'五星日记本', default=0)
    four_stars_diary = models.IntegerField(verbose_name=u'四星日记本', default=0)
    advertise = models.IntegerField(verbose_name=u'广告消耗', default=0)
    diary_pv = models.IntegerField(verbose_name=u'日记详情页', default=0)
    service_pv = models.IntegerField(verbose_name=u'美购详情页', default=0)
    hospital_doctor_pv = models.IntegerField(verbose_name=u'机构/医生主页详情页', default=0)
    phone = models.IntegerField(verbose_name=u'电话', default=0)
    message = models.IntegerField(verbose_name=u'私信', default=0)
    connect_phone = models.IntegerField(verbose_name=u'接通电话', default=0)
    effective_message = models.IntegerField(verbose_name=u'有效私信', default=0)
    to_the_hospital = models.IntegerField(verbose_name=u'到院', default=0)
    consumption_people = models.IntegerField(verbose_name=u'消费人数', default=0)
    consumption_cost = models.IntegerField(verbose_name=u'消费金额', default=0)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
    time_type = models.IntegerField(verbose_name=u'时间段枚举', choices=DATE_TYPE)  # todo 添加枚举
    diary_rank = models.IntegerField(verbose_name=u'日记同城排名', default=999999)

    @property
    def weight_pv(self):
        return self.diary_pv * 0.1 + self.service_pv + self.hospital_doctor_pv

    @property
    def to_hospital_rate(self):
        if self.phone + self.message > 0:
            return '{}%'.format((self.to_the_hospital * 100) / (self.phone + self.message))
        else:
            return '--'

    @property
    def success_order_rate(self):
        if self.to_the_hospital > 0:
            return '{}%'.format((self.consumption_people * 100) / self.to_the_hospital)
        else:
            return '--'

    def get_data(self):
        return {
            "new_diary": self.new_diary,
            "five_stars_diary": self.five_stars_diary,
            "four_stars_diary": self.four_stars_diary,
            "advertise": self.advertise,
            "diary_pv": self.diary_pv,
            "service_pv": self.service_pv,
            "hospital_doctor_pv": self.hospital_doctor_pv,
            "phone": self.phone,
            "message": self.message,
            "connect_phone": self.connect_phone,
            "effective_message": self.effective_message,
            "to_the_hospital": self.to_the_hospital,
            "consumption_people": self.consumption_people,
            "consumption_cost": self.consumption_cost,
            "diary_rank": self.diary_rank,
            'to_hospital_rate': self.to_hospital_rate,
            'success_order_rate': self.success_order_rate,
            'weight_pv': self.weight_pv
        }


class ToHospital(models.Model):
    class Meta:
        verbose_name = u'到院记录'
        db_table = 'hippo_to_hospital'
        app_label = 'hippo'

    tohospital_time = models.DateField(verbose_name=u'到院时间')
    doctor = models.ForeignKey(Doctor, verbose_name=u'医生')
    merchant = models.ForeignKey(Merchant, verbose_name=u'商户')
    created_time = models.DateTimeField(verbose_name=u'添加时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
    num = models.IntegerField(verbose_name=u'到院人数', default=0)


class Al_Merchant_Stat_Updates(models.Model):
    class Meta:
        verbose_name = u'pv统计'
        db_table = 'al_merchant_stat_updates'
        app_label = 'al'

    objects = models.Manager().db_manager(using=settings.DOCTOR_TRAFFIC_DB)

    date = models.DateField(verbose_name=u'计算当月1号到date的数据，日期记为partition_date')
    merchant_id = models.BigIntegerField(u'商户id')
    service_pv = models.BigIntegerField(u'美购详情页ID')
    home_pv = models.BigIntegerField(u'	医生主页PV+医院主页PV')
    diary_pv = models.BigIntegerField(u'日记本详情页PV+日记帖详情页PV')
