# -*- coding: utf-8 -*-
# @Time    : 2019/9/6 2:34 PM
# @Author  : Esse
# @FileName: quickreply.py

from rpc.decorators import bind_context, bind
from hippo.models.quick_reply import QuickReplyGroup, QucikReplyContent
from django.db.models import F


@bind('doctor/quickreply/group/list')
def group_list(doctor_id):
    """
    获取快捷回复分组列表
    :param doctor_id:
    :return:
    """
    groups = QuickReplyGroup.objects.filter(doctor_id=doctor_id).order_by('rank')
    list_data = [{
        'id': g.id,
        'name': g.name,
        'rank': g.rank
    } for g in groups]
    return {'total': groups.count(), 'group_list': list_data}


@bind('doctor/quickreply/group/edit')
def group_edit(doctor_id, name, group_id=None):
    """
    新增修改快捷回复分组
    :param doctor_id:
    :param group_id:
    :param name:
    :return:
    """
    if group_id:
        group = QuickReplyGroup.objects.get(id=group_id)
        group.name = name
        group.save()
    else:
        rank = QuickReplyGroup.objects.filter(doctor_id=doctor_id).count()
        group = QuickReplyGroup.objects.create(doctor_id=doctor_id, name=name, rank=rank)
    return {'id': group.id, 'name': group.name, 'rank': group.rank}


@bind('doctor/quickreply/group/delete')
def group_delete(group_id):
    """
    删除分组及所属所有回复
    :param group_id:
    :return:
    """
    qrg = QuickReplyGroup.objects.get(id=group_id)
    down_qrgs = QuickReplyGroup.objects.filter(doctor_id=qrg.doctor_id, rank__gt=qrg.rank)
    qrg.delete()
    # 上移此分组下的所有分组
    down_qrgs.update(rank=F('rank')-1)
    return {'id': group_id}


@bind('doctor/quickreply/group/rank')
def group_rank(group_id, is_up):
    """
    上移或下移分组
    :param group_id:
    :param is_up:
    :return:
    """
    group = QuickReplyGroup.objects.get(id=group_id)
    group.update_rank(is_up)
    return {'id': group.id}


@bind('doctor/quickreply/reply/list')
def reply_list(group_id):
    """
    获取快捷回复列表
    :param group_id:
    :return:
    """
    contents = QucikReplyContent.objects.filter(quickreplygroup_id=group_id).order_by('rank')
    list_data = [{
        'id': c.id,
        'name': c.name,
        'rank': c.rank
    } for c in contents]
    return {'total': contents.count(), 'reply_list': list_data}


@bind('doctor/quickreply/reply/edit')
def reply_edit(group_id, name, content_id=None):
    """
    新增 修改回复
    :param group_id:
    :param name:
    :param content_id:
    :return:
    """
    if content_id:
        content = QucikReplyContent.objects.get(id=content_id)
        content.name = name
        content.save()
    else:
        rank = QucikReplyContent.objects.filter(quickreplygroup_id=group_id).count()
        content = QucikReplyContent.objects.create(quickreplygroup_id=group_id, name=name, rank=rank)
    return {'id': content.id, 'name': content.name, 'rank': content.rank}


@bind('doctor/quickreply/reply/delete')
def reply_delete(content_id):
    """
    删除回复
    :param content_id:
    :return:
    """
    qrc = QucikReplyContent.objects.get(id=content_id)
    down_qrcs = QucikReplyContent.objects.filter(rank__gt=qrc.rank, quickreplygroup_id=qrc.quickreplygroup_id)
    qrc.delete()
    # 上移此回复之后的所有回复
    down_qrcs.update(rank=F('rank')-1)
    return {'id': content_id}


@bind('doctor/quickreply/reply/rank')
def reply_rank(content_id, is_up):
    """
    上移或下移回复
    :param content_id:
    :param is_up:
    :return:
    """
    content = QucikReplyContent.objects.get(id=content_id)
    content.update_rank(is_up)
    return {'id': content.id}
