# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import
from django.conf import settings
from gm_dbmw_api.descriptor import source, relation
from gm_types.mq.dbmw import DBMWEndPoints




pk_data_source =  source.GroupedSource.of(source.MySQLTableSource(
    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
    table_name='api_rankboard',
    key_columns=['id'],
    value_columns_all=True,
),source.MySQLTableSource(
    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
    table_name='api_rankboardshowcity',
    key_columns=['rankboard_id'],
    value_columns_all=True,
),
source.MySQLTableSource(
    logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
    table_name='api_rankboardshowregion',
    key_columns=['rankboard_id'],
    value_columns_all=True,
),
source.RelatedSource(
    source=source.GMMQSource(
        endpoint=DBMWEndPoints.GAIA_TAG,
    ),
    relation=relation.MySQLTableRelation(
        logical_database_id=settings.DBMW_LOGICAL_DATABASE_ID,
        table_name='api_rankboarddatatag',
        from_columns=['tag_id'],
        to_columns=['rankboard_id'],
    )
))

index_data_source = pk_data_source
