# coding=utf-8
from __future__ import unicode_literals, absolute_import
__all__ = ['get_settlement_expired_datetime', 'DatetimeTool']
import datetime


def get_settlement_expired_datetime():
    return datetime.datetime.now() + datetime.timedelta(days=365)


class DatetimeTool(object):
    def __init__(self, dt=None):
        self.dt = dt or datetime.datetime.now()

    def get_first_day_month(self, d_years=0, d_months=0):
        # d_years later, d_months later
        # for example 2016-01-01 00:00:00
        y, m = self.dt.year + d_years, self.dt.month + d_months
        a, m = divmod(m - 1, 12)
        return datetime.datetime(year=y + a, month=m + 1, day=1)

    def get_last_day_month(self):
        # for example 2016-01-31 23:59:59
        return self.get_first_day_month(0, 1) + datetime.timedelta(seconds=-1)
