# coding=utf-8
from __future__ import unicode_literals, absolute_import

from django.conf import settings
from django.core.management.base import NoArgsCommand

from search.utils.es import get_es, get_talos_es
from trans2es.utils.es import create_index
from trans2es.utils.es import init_alias

type_mapping = {
    'topic': 'problem',
    'tag': 'tag',
    'itemwiki': 'itemwiki',
    'diary': 'diary',
    'service': 'service',
    'doctor': 'doctor',
    'user': 'user',
    'question': 'question',
    'board':'board',
    'article':'article',
    'answer':'answer'
}


class Command(NoArgsCommand):
    def handle(self, *args, **options):
        es = get_es()
        if options['doc_type'] == '_all':
            for doc_type in type_mapping.values():
                create_index(es, settings.ES_INDEX_PREFIX, doc_type)
                init_alias(es, settings.ES_INDEX_PREFIX, doc_type)
        else:
            doc_type = options['doc_type']
            create_index(es, settings.ES_INDEX_PREFIX, doc_type)
            init_alias(es, settings.ES_INDEX_PREFIX, doc_type)

    def add_arguments(self, parser):
        parser.add_argument('doc_type', type=str)
