-- Deploy gaia:answer_2017_03_14_create_table_answer to mysql

BEGIN;

-- XXX Add DDLs here.
CREATE TABLE `api_question` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `title` varchar(128) NOT NULL,
    `content` longtext,
    `cover_url` varchar(300),
    `is_online` bool NOT NULL,
    `is_recommend` bool NOT NULL,
    `like_num` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_question` ADD CONSTRAINT `user_id_refs_id_e52daaee` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
CREATE TABLE `api_question_image` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `question_id` integer NOT NULL,
    `image_url` varchar(300) NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_question_image` ADD CONSTRAINT `question_id_refs_id_47a698fa` FOREIGN KEY (`question_id`) REFERENCES `api_question` (`id`);
CREATE TABLE `api_questiontag` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `question_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
ALTER TABLE `api_questiontag` ADD CONSTRAINT `tag_id_refs_id_7171dcab` FOREIGN KEY (`tag_id`) REFERENCES `api_tag` (`id`);
ALTER TABLE `api_questiontag` ADD CONSTRAINT `question_id_refs_id_4f1531ec` FOREIGN KEY (`question_id`) REFERENCES `api_question` (`id`);
CREATE TABLE `api_question_vote` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `question_id` integer NOT NULL,
    `unread` bool NOT NULL,
    `is_fake` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_question_vote` ADD CONSTRAINT `user_id_refs_id_2e6d12dd` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_question_vote` ADD CONSTRAINT `question_id_refs_id_eb91a19e` FOREIGN KEY (`question_id`) REFERENCES `api_question` (`id`);
CREATE TABLE `api_answer` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `content` longtext NOT NULL,
    `cover_url` varchar(300),
    `question_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `is_recommend` bool NOT NULL,
    `like_num` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_answer` ADD CONSTRAINT `user_id_refs_id_90a70485` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_answer` ADD CONSTRAINT `question_id_refs_id_a8d9d8ee` FOREIGN KEY (`question_id`) REFERENCES `api_question` (`id`);
CREATE TABLE `api_answer_image` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `answer_id` integer NOT NULL,
    `image_url` varchar(300) NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_answer_image` ADD CONSTRAINT `answer_id_refs_id_c5b4de85` FOREIGN KEY (`answer_id`) REFERENCES `api_answer` (`id`);
CREATE TABLE `api_answer_vote` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `answer_id` integer NOT NULL,
    `unread` bool NOT NULL,
    `is_fake` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    UNIQUE (`user_id`, `answer_id`)
)
;
ALTER TABLE `api_answer_vote` ADD CONSTRAINT `user_id_refs_id_4c85c82e` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_answer_vote` ADD CONSTRAINT `answer_id_refs_id_f966eccf` FOREIGN KEY (`answer_id`) REFERENCES `api_answer` (`id`);
CREATE TABLE `api_answer_reply` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `content` longtext NOT NULL,
    `answer_id` integer NOT NULL,
    `first_reply_id` integer,
    `commented_reply_id` integer,
    `is_online` bool NOT NULL,
    `like_num` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_answer_reply` ADD CONSTRAINT `user_id_refs_id_fd2c09fe` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_answer_reply` ADD CONSTRAINT `answer_id_refs_id_70a4f8e8` FOREIGN KEY (`answer_id`) REFERENCES `api_answer` (`id`);
ALTER TABLE `api_answer_reply` ADD CONSTRAINT `first_reply_id_refs_id_25a81d44` FOREIGN KEY (`first_reply_id`) REFERENCES `api_answer_reply` (`id`);
ALTER TABLE `api_answer_reply` ADD CONSTRAINT `commented_reply_id_refs_id_25a81d44` FOREIGN KEY (`commented_reply_id`) REFERENCES `api_answer_reply` (`id`);
CREATE TABLE `api_answerreply_vote` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `answerreply_id` integer NOT NULL,
    `unread` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `update_time` datetime(6) NOT NULL,
    UNIQUE (`user_id`, `answerreply_id`)
)
;
ALTER TABLE `api_answerreply_vote` ADD CONSTRAINT `user_id_refs_id_d63133c6` FOREIGN KEY (`user_id`) REFERENCES `auth_user` (`id`);
ALTER TABLE `api_answerreply_vote` ADD CONSTRAINT `answerreply_id_refs_id_5a45e92d` FOREIGN KEY (`answerreply_id`) REFERENCES `api_answer_reply` (`id`);
CREATE INDEX `api_question_6340c63c` ON `api_question` (`user_id`);
CREATE INDEX `api_question_image_25110688` ON `api_question_image` (`question_id`);
CREATE INDEX `api_questiontag_25110688` ON `api_questiontag` (`question_id`);
CREATE INDEX `api_questiontag_5659cca2` ON `api_questiontag` (`tag_id`);
CREATE INDEX `api_question_vote_6340c63c` ON `api_question_vote` (`user_id`);
CREATE INDEX `api_question_vote_25110688` ON `api_question_vote` (`question_id`);
CREATE INDEX `api_answer_6340c63c` ON `api_answer` (`user_id`);
CREATE INDEX `api_answer_25110688` ON `api_answer` (`question_id`);
CREATE INDEX `api_answer_image_5b4ce3ea` ON `api_answer_image` (`answer_id`);
CREATE INDEX `api_answer_vote_6340c63c` ON `api_answer_vote` (`user_id`);
CREATE INDEX `api_answer_vote_5b4ce3ea` ON `api_answer_vote` (`answer_id`);
CREATE INDEX `api_answer_reply_6340c63c` ON `api_answer_reply` (`user_id`);
CREATE INDEX `api_answer_reply_5b4ce3ea` ON `api_answer_reply` (`answer_id`);
CREATE INDEX `api_answer_reply_ba9453f6` ON `api_answer_reply` (`commented_reply_id`);
CREATE INDEX `api_answerreply_vote_6340c63c` ON `api_answerreply_vote` (`user_id`);
CREATE INDEX `api_answerreply_vote_587ac552` ON `api_answerreply_vote` (`answerreply_id`);

COMMIT;
