-- Deploy gaia:api_2016_12_01_create_table_region_table_special_show_services to mysql

BEGIN;

CREATE TABLE `api_region` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `english_name` varchar(40) NOT NULL,
    `name` varchar(40) NOT NULL
)
;

CREATE TABLE `api_gadgetregion` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `gadget_id` integer NOT NULL,
    `region_id` integer NOT NULL
)
;
ALTER TABLE `api_gadgetregion` ADD CONSTRAINT `gadget_id_refs_id_c66591f7` FOREIGN KEY (`gadget_id`) REFERENCES `api_gadget` (`id`);
ALTER TABLE `api_gadgetregion` ADD CONSTRAINT `region_id_refs_id_478edd18` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);

CREATE TABLE `api_gadgetcity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `gadget_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL
)
;
ALTER TABLE `api_gadgetcity` ADD CONSTRAINT `gadget_id_refs_id_78c26502` FOREIGN KEY (`gadget_id`) REFERENCES `api_gadget` (`id`);
ALTER TABLE `api_gadgetcity` ADD CONSTRAINT `city_id_refs_id_9a8d98f0` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);


CREATE TABLE `api_showregion` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `region_id` integer NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `slide_id` integer NOT NULL
)
;
ALTER TABLE `api_showregion` ADD CONSTRAINT `slide_id_refs_id_0fa7985d` FOREIGN KEY (`slide_id`) REFERENCES `api_slide` (`id`);
ALTER TABLE `api_showregion` ADD CONSTRAINT `region_id_refs_id_87f4e998` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);

ALTER TABLE `api_province` ADD COLUMN `region_id` integer;
ALTER TABLE `api_province` ADD CONSTRAINT `region_id_refs_id_e923fc7e` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);

CREATE TABLE `api_specialexterior` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(64) NOT NULL,
    `image` varchar(300) NOT NULL,
    `start_time` datetime(6),
    `end_time` datetime(6),
    `rank` integer NOT NULL,
    `is_online` bool NOT NULL,
    `special_id` integer NOT NULL
)
;
ALTER TABLE `api_specialexterior` ADD CONSTRAINT `special_id_refs_id_44b2fbb0` FOREIGN KEY (`special_id`) REFERENCES `api_special` (`id`);

CREATE TABLE `api_specialexteriorregion` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `special_exterior_id` integer NOT NULL,
    `region_id` integer NOT NULL
)
;
ALTER TABLE `api_specialexteriorregion` ADD CONSTRAINT `special_exterior_id_refs_id_ff2b4673` FOREIGN KEY (`special_exterior_id`) REFERENCES `api_specialexterior` (`id`);
ALTER TABLE `api_specialexteriorregion` ADD CONSTRAINT `region_id_refs_id_b7041d22` FOREIGN KEY (`region_id`) REFERENCES `api_region` (`id`);

CREATE TABLE `api_specialexteriorcity` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `special_exterior_id` integer NOT NULL,
    `city_id` varchar(40) NOT NULL
)
;
ALTER TABLE `api_specialexteriorcity` ADD CONSTRAINT `special_exterior_id_refs_id_60b0b721` FOREIGN KEY (`special_exterior_id`) REFERENCES `api_specialexterior` (`id`);
ALTER TABLE `api_specialexteriorcity` ADD CONSTRAINT `city_id_refs_id_ad7d1a2c` FOREIGN KEY (`city_id`) REFERENCES `api_city` (`id`);

CREATE TABLE `api_specialexteriorservice` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `special_exterior_id` integer NOT NULL,
    `service_id` integer NOT NULL
)
;
ALTER TABLE `api_specialexteriorservice` ADD CONSTRAINT `special_exterior_id_refs_id_0120f1db` FOREIGN KEY (`special_exterior_id`) REFERENCES `api_specialexterior` (`id`);
ALTER TABLE `api_specialexteriorservice` ADD CONSTRAINT `service_id_refs_id_9f8b75c3` FOREIGN KEY (`service_id`) REFERENCES `api_service` (`id`);

COMMIT;
