-- Deploy gaia:hera_viewmodel_for_diary to mysql

BEGIN;

CREATE TABLE `hera_vm_diary` (
    `vm_updated_time` datetime(6) NOT NULL,
    `id` integer NOT NULL PRIMARY KEY,
    `relobj_id` integer NOT NULL,
    `title` varchar(128) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `last_modified` datetime(6) NOT NULL,
    `last_topic_add_time` datetime(6),
    `price` integer NOT NULL,
    `reply_num` integer NOT NULL,
    `rating` double precision NOT NULL,
    `is_online` bool NOT NULL,
    `is_sink` bool NOT NULL,
    `operation_time` datetime(6),
    `is_headline` bool NOT NULL,
    `is_essence` bool NOT NULL,
    `content_level` varchar(1) NOT NULL,
    `audit_status` varchar(1) NOT NULL,
    `audit_time` datetime(6),
    `not_empty` bool NOT NULL,
    `not_review_topic_num` integer NOT NULL,
    `user_id` integer NOT NULL,
    `user_nickname` varchar(30) NOT NULL,
    `doctor_id` varchar(100),
    `doctor_name` varchar(200) NOT NULL,
    `hospital_id` varchar(100),
    `hospital_name` varchar(100) NOT NULL,
    `order_id` varchar(12),
    `order_is_self_support` bool NOT NULL,
    `order_status` varchar(20),
    `order_cash_back_status` varchar(1),
    `order_validated` bool NOT NULL,
    `order_cashback_id` varchar(15),
    `order_cashback_time` datetime(6),
    `service_id` integer,
    `service_name` varchar(100) NOT NULL,
    `service_is_online` bool NOT NULL,
    `diaryrank_id` integer,
    `diaryrank_additional_score` integer NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
;
ALTER TABLE `hera_vm_diary` ADD CONSTRAINT `relobj_id_refs_id_96c7ec72` FOREIGN KEY (`relobj_id`) REFERENCES `api_diary` (`id`);
CREATE TABLE `hera_vm_diary_tags` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `vm_updated_time` datetime(6) NOT NULL,
    `diary_id` integer NOT NULL,
    `tag_id` integer NOT NULL
)
;
ALTER TABLE `hera_vm_diary_tags` ADD CONSTRAINT `diary_id_refs_id_6892562f` FOREIGN KEY (`diary_id`) REFERENCES `hera_vm_diary` (`id`);
CREATE INDEX `hera_vm_diary_9569e726` ON `hera_vm_diary` (`relobj_id`);
CREATE INDEX `hera_vm_diary_9246ed76` ON `hera_vm_diary` (`title`);
CREATE INDEX `hera_vm_diary_41e5f0d8` ON `hera_vm_diary` (`created_time`);
CREATE INDEX `hera_vm_diary_5ccb38e5` ON `hera_vm_diary` (`last_modified`);
CREATE INDEX `hera_vm_diary_d5c1cf5e` ON `hera_vm_diary` (`last_topic_add_time`);
CREATE INDEX `hera_vm_diary_5a5255da` ON `hera_vm_diary` (`price`);
CREATE INDEX `hera_vm_diary_18fbd888` ON `hera_vm_diary` (`reply_num`);
CREATE INDEX `hera_vm_diary_07e184f8` ON `hera_vm_diary` (`rating`);
CREATE INDEX `hera_vm_diary_876b3fca` ON `hera_vm_diary` (`operation_time`);
CREATE INDEX `hera_vm_diary_1ffdedc6` ON `hera_vm_diary` (`user_id`);
CREATE INDEX `hera_vm_diary_0a4fb719` ON `hera_vm_diary` (`user_nickname`);
CREATE INDEX `hera_vm_diary_3505b1b3` ON `hera_vm_diary` (`doctor_id`);
CREATE INDEX `hera_vm_diary_fc5484aa` ON `hera_vm_diary` (`doctor_name`);
CREATE INDEX `hera_vm_diary_4963442f` ON `hera_vm_diary` (`hospital_id`);
CREATE INDEX `hera_vm_diary_d0b57823` ON `hera_vm_diary` (`hospital_name`);
CREATE INDEX `hera_vm_diary_1b89fe59` ON `hera_vm_diary` (`order_id`);
CREATE INDEX `hera_vm_diary_9e861934` ON `hera_vm_diary` (`order_cashback_id`);
CREATE INDEX `hera_vm_diary_5a8e60a2` ON `hera_vm_diary` (`service_id`);
CREATE INDEX `hera_vm_diary_48f8ebf4` ON `hera_vm_diary` (`service_name`);
CREATE INDEX `hera_vm_diary_tags_67548958` ON `hera_vm_diary_tags` (`diary_id`);


COMMIT;
