-- Deploy gaia:wiki_20180129_create_wiki_models to mysql

BEGIN;

CREATE TABLE `wiki_brand` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(48) NOT NULL,
    `image_url` varchar(128) NOT NULL,
    `description` longtext NOT NULL,
    `theory` longtext NOT NULL,
    `company` varchar(48) NOT NULL,
    `market_time` varchar(48) NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `soyoung_id` integer NOT NULL
)
;
CREATE TABLE `wiki_product_similar_product` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `from_product_id` integer NOT NULL,
    `to_product_id` integer NOT NULL,
    UNIQUE (`from_product_id`, `to_product_id`)
)
;
CREATE TABLE `wiki_product` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `soyoung_id` integer,
    `icon` varchar(128) NOT NULL,
    `name` varchar(50) NOT NULL,
    `other_name` varchar(100) NOT NULL,
    `product_type` varchar(4) NOT NULL,
    `brand_id` integer,
    `origin` varchar(48) NOT NULL,
    `description` longtext NOT NULL,
    `special` longtext NOT NULL,
    `theory` longtext NOT NULL,
    `effect` varchar(128) NOT NULL,
    `application_range` varchar(128) NOT NULL,
    `advantage` longtext NOT NULL,
    `disadvantage` longtext NOT NULL,
    `after_know` longtext NOT NULL,
    `safe_tips` longtext NOT NULL,
    `verify_url` varchar(256) NOT NULL,
    `clinical` varchar(50) NOT NULL,
    `ingredient` longtext NOT NULL,
    `treatment_method` varchar(8) NOT NULL,
    `anesthesia_method` varchar(8) NOT NULL,
    `ache_level` varchar(8) NOT NULL,
    `price` varchar(50) NOT NULL,
    `hospitalized` bool NOT NULL,
    `treatment_time` varchar(50) NOT NULL,
    `maintain_time` varchar(50) NOT NULL,
    `recover_time` varchar(50) NOT NULL,
    `treatment_num` varchar(50) NOT NULL,
    `treatment_doctor` varchar(50) NOT NULL,
    `is_hot` bool NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `similar_sy_product` varchar(500) NOT NULL
)
;
ALTER TABLE `wiki_product` ADD CONSTRAINT `brand_id_refs_id_93602ae6` FOREIGN KEY (`brand_id`) REFERENCES `wiki_brand` (`id`);
ALTER TABLE `wiki_product_similar_product` ADD CONSTRAINT `from_product_id_refs_id_3eb82446` FOREIGN KEY (`from_product_id`) REFERENCES `wiki_product` (`id`);
ALTER TABLE `wiki_product_similar_product` ADD CONSTRAINT `to_product_id_refs_id_3eb82446` FOREIGN KEY (`to_product_id`) REFERENCES `wiki_product` (`id`);
CREATE TABLE `wiki_productpararms` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `product_id` integer NOT NULL,
    `params_type` varchar(8) NOT NULL,
    `params_message` varchar(256) NOT NULL
)
;
ALTER TABLE `wiki_productpararms` ADD CONSTRAINT `product_id_refs_id_95fa67a6` FOREIGN KEY (`product_id`) REFERENCES `wiki_product` (`id`);
CREATE TABLE `wiki_productimage` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `product_id` integer NOT NULL,
    `info` varchar(256) NOT NULL,
    `image_type` varchar(8) NOT NULL,
    `image_url` varchar(128) NOT NULL,
    `is_online` bool NOT NULL
)
;
ALTER TABLE `wiki_productimage` ADD CONSTRAINT `product_id_refs_id_913be431` FOREIGN KEY (`product_id`) REFERENCES `wiki_product` (`id`);
CREATE TABLE `wiki_productattestation` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `product_id` integer NOT NULL,
    `attestation_type` varchar(8) NOT NULL,
    `attestation_image` varchar(128),
    `is_online` bool NOT NULL
)
;
ALTER TABLE `wiki_productattestation` ADD CONSTRAINT `product_id_refs_id_6f217180` FOREIGN KEY (`product_id`) REFERENCES `wiki_product` (`id`);
CREATE TABLE `wiki_item_related_product` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `item_id` integer NOT NULL,
    `product_id` integer NOT NULL,
    UNIQUE (`item_id`, `product_id`)
)
;
ALTER TABLE `wiki_item_related_product` ADD CONSTRAINT `product_id_refs_id_80725afd` FOREIGN KEY (`product_id`) REFERENCES `wiki_product` (`id`);
CREATE TABLE `wiki_item_similar_item` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `from_item_id` integer NOT NULL,
    `to_item_id` integer NOT NULL,
    UNIQUE (`from_item_id`, `to_item_id`)
)
;
CREATE TABLE `wiki_item` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `soyoung_id` integer,
    `name` varchar(48) NOT NULL,
    `icon` varchar(128) NOT NULL,
    `other_name` varchar(100) NOT NULL,
    `description` longtext NOT NULL,
    `effect` longtext NOT NULL,
    `use_result` varchar(128) NOT NULL,
    `fit_people` longtext NOT NULL,
    `avoid_people` longtext NOT NULL,
    `advantage` longtext NOT NULL,
    `disadvantage` longtext NOT NULL,
    `treatment_method` varchar(8) NOT NULL,
    `anesthesia_method` varchar(8) NOT NULL,
    `ache_level` varchar(8) NOT NULL,
    `price` varchar(50) NOT NULL,
    `hospitalized` bool NOT NULL,
    `treatment_time` varchar(50) NOT NULL,
    `maintain_time` varchar(50) NOT NULL,
    `recover_time` varchar(50) NOT NULL,
    `treatment_num` varchar(50) NOT NULL,
    `treatment_doctor` varchar(50) NOT NULL,
    `pre_know` longtext NOT NULL,
    `is_hot` bool NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL,
    `similar_sy_item` varchar(500) NOT NULL,
    `related_sy_drug` varchar(500) NOT NULL
)
;
ALTER TABLE `wiki_item_related_product` ADD CONSTRAINT `item_id_refs_id_a69fe9b5` FOREIGN KEY (`item_id`) REFERENCES `wiki_item` (`id`);
ALTER TABLE `wiki_item_similar_item` ADD CONSTRAINT `from_item_id_refs_id_3be59c08` FOREIGN KEY (`from_item_id`) REFERENCES `wiki_item` (`id`);
ALTER TABLE `wiki_item_similar_item` ADD CONSTRAINT `to_item_id_refs_id_3be59c08` FOREIGN KEY (`to_item_id`) REFERENCES `wiki_item` (`id`);
CREATE TABLE `wiki_itemafterknow` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `item_id` integer NOT NULL,
    `title` varchar(50) NOT NULL,
    `rank` integer NOT NULL,
    `recover_tips` varchar(128) NOT NULL,
    `care_method` longtext NOT NULL,
    `is_online` bool NOT NULL
)
;
ALTER TABLE `wiki_itemafterknow` ADD CONSTRAINT `item_id_refs_id_8e7764b4` FOREIGN KEY (`item_id`) REFERENCES `wiki_item` (`id`);
CREATE TABLE `wiki_collect` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `name` varchar(48) NOT NULL,
    `description` longtext NOT NULL,
    `is_online` bool NOT NULL,
    `create_time` datetime(6) NOT NULL
)
;
CREATE TABLE `wiki_collectitem` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `collect_id` integer NOT NULL,
    `item_id` integer NOT NULL,
    `rank` integer NOT NULL,
    `is_online` bool NOT NULL
)
;
ALTER TABLE `wiki_collectitem` ADD CONSTRAINT `item_id_refs_id_6fe687dd` FOREIGN KEY (`item_id`) REFERENCES `wiki_item` (`id`);
ALTER TABLE `wiki_collectitem` ADD CONSTRAINT `collect_id_refs_id_44be094a` FOREIGN KEY (`collect_id`) REFERENCES `wiki_collect` (`id`);
CREATE TABLE `wiki_directory` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `dirctory_type` varchar(20) NOT NULL,
    `model_type` varchar(20) NOT NULL,
    `rank` integer NOT NULL,
    `brand_id` integer,
    `product_id` integer,
    `collect_id` integer,
    `is_online` bool NOT NULL
)
;
ALTER TABLE `wiki_directory` ADD CONSTRAINT `brand_id_refs_id_195b4081` FOREIGN KEY (`brand_id`) REFERENCES `wiki_brand` (`id`);
ALTER TABLE `wiki_directory` ADD CONSTRAINT `product_id_refs_id_89020ddf` FOREIGN KEY (`product_id`) REFERENCES `wiki_product` (`id`);
ALTER TABLE `wiki_directory` ADD CONSTRAINT `collect_id_refs_id_cd9e01ba` FOREIGN KEY (`collect_id`) REFERENCES `wiki_collect` (`id`);

CREATE INDEX `wiki_product_name` ON `wiki_product` (`name`);
CREATE INDEX `wiki_brand_name` ON `wiki_brand` (`name`);
CREATE INDEX `wiki_collect_name` ON `wiki_collect` (`name`);

COMMIT;
