# -*- coding: UTF-8 -*-
from django.db import models
from gm_types.gaia import REPORT_TYPE, REPORT_REASON, REPORT_ACTIONS

from talos.models.diary import Diary
from talos.models.topic import Problem
from talos.models.topic import TopicReply


class Report(models.Model):
    class Meta:
        verbose_name = u'80. 举报'
        verbose_name_plural = u'80. 举报'
        db_table = 'api_report'
        app_label = 'api'

    user_id = models.IntegerField(null=True, blank=True, verbose_name=u"举报人")
    problem = models.ForeignKey(Problem, null=True, blank=True, related_name='report_topic', verbose_name=u"被举报的话题")
    diary = models.ForeignKey(Diary, null=True, blank=True, related_name='report_diary', verbose_name=u'被举报的日记本')
    topic_reply = models.ForeignKey(TopicReply, null=True, blank=True, related_name='report_reply',
                                    verbose_name=u"被举报的回复")
    type = models.CharField(max_length=1, verbose_name=u'举报类型', null=False, blank=False,
                            default=REPORT_TYPE.TOPIC, choices=REPORT_TYPE)
    reason = models.CharField(max_length=1, choices=REPORT_REASON, null=False, default=REPORT_REASON.AD,
                              verbose_name=u'举报原因')
    report_time = models.DateTimeField(auto_now_add=True, verbose_name=u'举报时间')
    is_handled = models.BooleanField(default=False, verbose_name=u'是否已经处理')
    action = models.CharField(max_length=1, choices=REPORT_ACTIONS, null=True, default=REPORT_ACTIONS.UNHANDLED,
                              verbose_name=u'处理动作')


class FilterWord(models.Model):
    class Meta:
        verbose_name = u'关键词过滤'
        verbose_name_plural = u'关键词过滤'
        db_table = 'api_filterword'
        app_label = 'api'

    word = models.CharField(max_length=100, null=False, verbose_name=u'敏感词')
    in_user_name = models.BooleanField(verbose_name=u'用户名限制', default=True)
    in_topic_content = models.BooleanField(verbose_name=u'内容限制', default=True)
    in_topic_reply = models.BooleanField(verbose_name=u'回复限制', default=True)
    in_topic_chat = models.BooleanField(verbose_name=u'私信限制', default=True)
    add_time = models.DateTimeField(auto_now_add=True, verbose_name=u'添加时间')
    is_filter = models.BooleanField(default=True, verbose_name=u"是否过滤")

    def __unicode__(self):
        return self.word
