# -*- coding: UTF-8 -*-

from django.conf import settings

from talos import TopicReply
from talos.models.diary import Diary
from talos.models.topic import Problem, Video


def get_topic_reply_by_id(reply_id):
    """
    给定id, 获取对应的topic_reply
    @param reply_id:
    @return:
    """
    topic_replies = list(TopicReply.objects.filter(id=reply_id)[:1])
    if topic_replies:
        return topic_replies[0]
    else:
        return None


def modify_diary_video_tag_by_topic_ids(topic_ids):
    """
    供hera使用，修改日记本视频标签
    :param topic_ids:
    :return:
    """
    diary_ids = list(Problem.objects.filter(pk__in=topic_ids).values_list("diary_id", flat=True))

    for diary in Diary.objects.filter(pk__in=diary_ids):
        _topic_ids = list(Problem.objects.filter(diary=diary, is_online=True).values_list("id", flat=True))
        if Video.objects.filter(topic_id__in=_topic_ids).exists():
            diary.add_tags([settings.VIDEO_TAG_ID])
        else:
            diary.del_tags([settings.VIDEO_TAG_ID])