# coding=utf-8
from __future__ import unicode_literals, print_function, absolute_import


class HiddenDict(dict):

    def __repr__(self):
        return 'dict()'


class HiddenList(list):

    def __repr__(self):
        return 'list()'


def hide(obj):
    if isinstance(obj, dict):
        return HiddenDict(obj)
    if isinstance(obj, list):
        return HiddenList(obj)
    raise Exception('unsupported type: {}, {}'.format(repr(obj), obj.__class__.__name__))
