#! /usr/bin/env python
# -*- coding: utf-8 -*-

import xlrd
from django.core.management import BaseCommand

from api.models import College


def assemble_data():
    xls_file = xlrd.open_workbook("college.xlsx")
    xls_sheet = xls_file.sheets()[0]
    college_obj_list = []

    for line in range(0, xls_sheet.nrows):
        row_value = xls_sheet.row_values(line)
        create_kwargs = {
            'name': row_value[1],
            'level': row_value[2],
            'city_id': row_value[3],
        }

        college_obj_list.append(College(**create_kwargs))
    College.objects.bulk_create(college_obj_list)


class Command(BaseCommand):

    def handle(self, *args, **options):
        print('----------开始数据导入-----------------')
        assemble_data()
        print('----------数据导入完成-----------------')


