# coding=utf-8
from django.core.management import BaseCommand

from api.models import SpecialItem
from api.models import Province, City

provice_dict = {
    '华南': (
        ["广东", "福建", "海南", "澳门", "台湾", "香港"],
        [6142, 6139, 6148, 6162, 6158, 6153]
    ),
    '华西': (
        ["云南", "新疆", "贵州", "四川", "山西", "陕西", "甘肃", "重庆", "西藏", "青海", "宁夏"],
        [6144, 6136, 6146, 6160, 6156, 6151]
    ),
    '华北': (
        ["湖北", "湖南", "江西", "广西", "天津", "北京", "辽宁", "吉林", "黑龙江", "河北", "内蒙古"],
        [6143, 6138, 6149, 6164, 6159, 6154]
    ),
    '华东': (
        ["河南", "江苏", "上海", "安徽", "山东", "浙江"],
        [6140, 6137, 6033, 6152, 6155, 6145]
    ),
}


class Command(BaseCommand):
    def handle(self, *args, **options):

        for k, v in provice_dict.iteritems():
            provice_ids = []
            provice_name_list, special_ids = v
            print("开始处理{k}数据!".format(k=k))
            for provice_name in provice_name_list:
                p = Province.objects.filter(name__contains=provice_name).last()
                provice_ids.append(p.id)
            city_ids = City.objects.filter(province_id__in=provice_ids).values_list('id', flat=True)

            wait_delete_specialitems = SpecialItem.objects.filter(special_id__in=special_ids).exclude(
                serviceitem__service__doctor__hospital__city_id__in=city_ids
            )
            print("total count: {count}".format(wait_delete_specialitems.count()))
            for specialitem in wait_delete_specialitems:
                print("specialitem_id: {specialitem_id}, "
                      "special_id: {special_id}, "
                      "doctorseckillapply_id: {doctorseckillapply_id}, "
                      "serviceitem_id: {serviceitem_id}, "
                      "floor_id: {floor_id}".format(
                        specialitem_id=specialitem.id,
                        special_id=specialitem.special_id,
                        doctorseckillapply_id=specialitem.doctorseckillapply_id,
                        serviceitem_id=specialitem.serviceitem_id,
                        floor_id=specialitem.floor_id
                    ))
                specialitem.disable_price()
                specialitem.delete()

            print("{k}数据处理完毕!".format(k=k))
        print("done!")