#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   zhangxiaolin
#   E-mail  :   petelin1120@gmail.com
#   Date    :   17/8/3 10:49
#   Desc    :   处理2017年7月的数据, 使得补单结算单状态为成功的所有补单状态也改为成功


import datetime
from django.core.management import BaseCommand
from gm_types.gaia import BUDAN_SETTLEMENT_STATUS, BUDAN_STATUS

from api.models import BuDanSettlement, BuDan


class Command(BaseCommand):
    def handle(self, *args, **options):
        date = datetime.date(2017, 07, 1)
        ids = BuDanSettlement.objects.filter(month_at=date, status=BUDAN_SETTLEMENT_STATUS.PAY_SUCCESS).values_list("id", flat=True)
        for settlement_id in ids:
            BuDan.objects.filter(settlement_id=settlement_id).update(status=BUDAN_STATUS.PAY_SUCCESS)
