from gm_upload import batch_move_watermark_pic_to_no_watermark
from django.core.management import BaseCommand

from answer.models import Question, Answer


def get_short_path(url):
    url = url.replace('http://pic.gmei.com/', '')
    url = url.replace('http://hera.s.gmei.com/', '')
    return url


class Command(BaseCommand):
    def handle(self, *args, **options):
        questions = Question.objects.all()
        imgs = []
        for question in questions:
            if question.cover_url:
                imgs.append(get_short_path(question.cover_url))
        t = batch_move_watermark_pic_to_no_watermark(imgs, 'wanmeizhensuo', 'hera')

        imgs = []
        answers = Answer.objects.all()
        for answer in answers:
            if answer.cover_url:
                imgs.append(get_short_path(answer.cover_url))
        t = batch_move_watermark_pic_to_no_watermark(imgs, 'wanmeizhensuo', 'hera')
