# -*- coding: utf-8 -*-

import json

from django.utils import timezone
from django.db.models import Q
from django.conf import settings
from django.core.management import BaseCommand

from api.models import Doctor
from api.models import Service
from api.models import Hospital
from api.models import Order
from talos.models.diary import Diary
from talos.models.tractate import SoftArticle


class Command(BaseCommand):

    def handle(self, *args, **kwargs):

        with open("./online_diary_ids.txt") as f:
            diary_ids = f.readlines()

        for diary_id in diary_ids:
            diary_id = int(diary_id.strip())
            try:
                diary = Diary.objects.get(pk=diary_id)
                if not diary.is_online:
                    print(diary_id)
                    diary.is_online = True
                    diary.save()
            except:
                print("err: {diary_id}".format(diary_id=diary_id))
