#!/usr/bin/env python
# encoding=utf-8

from django.core.management import BaseCommand
from api.models import MerchantRelevance, Doctor, Merchant


class Command(BaseCommand):

    def handle(self, *args, **options):
        merchant_infos = Merchant.objects.filter(is_online=True).values(
            "id", "doctor__business_partener_id", "doctor__business_group")

        for merchant in merchant_infos:
            print("start to handle, merchant_id: ", merchant['id'])
            data = {
                'business_group': merchant['doctor__business_group'],
                'business_partener_id': merchant['doctor__business_partener_id'],
            }
            Doctor.objects.filter(id__in=list(
                MerchantRelevance.objects.filter(merchant_id=merchant['id']).values_list('doctor_id', flat=True)
            )).update(**data)
        print("done!")
