#! /usr/bin/env python
# -*- coding: utf-8 -*-
# create by oldman
# Date: 2019/7/7
from django.core.management import BaseCommand
from gm_types.gaia import ORDER_STATUS

from api.models import Order
from api.models import UserExtra
from api.models import UserNewOld


class Command(BaseCommand):
    """
    python manage.py update_2019_07_07_table_user_new_old
    同步用户的属性(是否是新老用户)
    """
    def handle(self, *args, **options):
        userextras = list(UserExtra.objects.all().values_list('user_id', flat=True))
        begin = 0
        step =10000
        count = len(userextras)
        while begin < count:
            for user_id in userextras[begin: step+begin]:
                try:
                    is_new = not Order.objects.filter(user_id=user_id).exclude(status=ORDER_STATUS.NOT_PAID).exists()
                    UserNewOld.objects.create(user_id=user_id,
                                              is_new= is_new)
                    print user_id
                except Exception as e:
                    print(e)
                    continue
            begin += step

