# coding=utf-8
from django.db import models
from gm_upload import ImgUrlField, IMG_TYPE
from gm_types.gaia import BASE_BAR_CONFIG
from ordered_model.models import OrderedModel


class Icon(OrderedModel):
    class Meta:
        verbose_name = u'icon 配置'
        db_table = 'api_icon'

    title = models.CharField(verbose_name='名称', max_length=20, unique=True)
    title_id = models.CharField(verbose_name='索引', max_length=20, unique=True)
    color = models.CharField(verbose_name='色号', max_length=50, default='')
    image = ImgUrlField(img_type=IMG_TYPE.ICON, max_length=1024, default='', verbose_name=u'icon图片')
    old_image = ImgUrlField(img_type=IMG_TYPE.ICON, max_length=1024, default='', verbose_name=u'老版本图片')
    url = models.CharField(max_length=1024, verbose_name='跳转链接', default='')
    is_online = models.BooleanField(verbose_name='是否启用', default=False)
    create_time = models.DateTimeField(verbose_name='创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name='最后更新时间', auto_now=True)

    def to_dict(self):
        result = {
            'title': self.title,
            'title_id': self.title_id,
            'order': self.order,
            'color': self.color,
            'image': self.image,
            'old_image': self.old_image,  # 7130版本兼容alert_table_icon_add_column_old_image
            'url': self.url,
            'is_online': self.is_online
        }
        return result


class ServiceJumpConfig(models.Model):
    class Meta:
        verbose_name = u'美购首页默认跳转配置'
        db_table = 'api_service_index_jump'
        app_label = 'api'

    name = models.CharField(verbose_name='名称', max_length=20, unique=True)
    url = models.CharField(max_length=1024, verbose_name='跳转链接', default='')
    start_time = models.DateTimeField(verbose_name='开始生效时间')
    end_time = models.DateTimeField(verbose_name='生效结束时间')
    is_online = models.BooleanField(verbose_name='是否启用', default=False)
    create_time = models.DateTimeField(verbose_name='创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name='最后更新时间', auto_now=True)


class IndexDefaultBar(models.Model):
    class Meta:
        verbose_name = u"默认选中的底部Bar配置"
        db_table = "api_default_bar"
        app_label = 'api'

    bar_type = models.IntegerField(verbose_name=u'类型', default=BASE_BAR_CONFIG.INDEX, choices=BASE_BAR_CONFIG,
                                   max_length=4)
    start_time = models.DateTimeField(verbose_name='开始生效时间')
    end_time = models.DateTimeField(verbose_name='生效结束时间')
    is_online = models.BooleanField(verbose_name='是否启用', default=False)
    create_time = models.DateTimeField(verbose_name='创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name='最后更新时间', auto_now=True)