# -*- coding: utf-8 -*-

from django.db import models

from api.tool.datetime_tool import get_timestamp


class IndustryNews(models.Model):
    class Meta:
        verbose_name = u'行业动态'
        verbose_name_plural = u'行业动态'
        db_table = 'api_industry_news'
        app_label = 'api'

    title = models.CharField(u'标题', max_length=50, db_index=True)
    content = models.TextField(u'内容', default='')
    ordering = models.IntegerField(u'排序', default=0)
    begin_time = models.DateTimeField(u'发布开始时间')
    end_time = models.DateTimeField(u'发布结束时间', null=True)
    is_online = models.BooleanField(u'是否上线', default=False)
    created_time = models.DateTimeField(u'创建时间', auto_now_add=True)
    updated_time = models.DateTimeField(u'更新时间', auto_now=True)
