# coding=utf-8
from django.contrib.auth.models import User
from django.db import models


class OperateTeam(models.Model):
    class Meta:
        verbose_name = u'运营商务小组划分'
        db_table = 'api_operate_team'
        app_label = 'api'

    name = models.CharField(verbose_name='小组名称', max_length=30)
    note = models.CharField(verbose_name='备注', max_length=200)
    created_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True, null=True, blank=True)


class OperateTeamRealatedOperate(models.Model):
    class Meta:
        verbose_name = u'运营商务小组关联运营人员'
        db_table = 'api_operate_team_operate'
        app_label = 'api'

    operate = models.ForeignKey(OperateTeam, verbose_name=u'运营小组id')
    user = models.ForeignKey(User, verbose_name=u'运营人员ID')
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True, null=True, blank=True)


class OperateTeamReleatedBusiness(models.Model):
    class Meta:
        verbose_name = u'运营商务小组关联商务人员'
        db_table = 'api_operate_team_business'
        app_label = 'api'

    operate = models.ForeignKey(OperateTeam, verbose_name=u'运营小组id')
    user = models.ForeignKey(User, verbose_name=u'商务人员ID')
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True, null=True, blank=True)
