#! /usr/bin/env python
# -*- coding: utf-8 -*-

from django.db import models
from gm_upload import IMG_TYPE
from gm_upload import ImgUrlField


class FaceOneImage(models.Model):
    class Meta:
        verbose_name = "扫脸一张图"
        verbose_name_plural = "扫脸一张图"
        db_table = 'api_face_one_image'

    face_id = models.CharField(verbose_name=u"人脸扫描唯一id", max_length=128, unique=True, null=False, default='')
    user_id = models.BigIntegerField(verbose_name=u'用户ID', null=False, db_index=True, default=0)
    face_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'脸部照片地址', default='')
    is_online = models.BooleanField(null=False, default=True, verbose_name='是否上线')
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)


class FaceOneImageV2(models.Model):
    class Meta:
        verbose_name = "扫脸新的记录库"
        verbose_name_plural = "扫脸新的记录库"
        db_table = 'api_face_one_image_v2'

    face_id = models.CharField(verbose_name=u"人脸扫描唯一id", max_length=128, unique=True, null=False, default='')
    user_id = models.BigIntegerField(verbose_name=u'用户ID', db_index=True, default=0)
    face_url = ImgUrlField(img_type=IMG_TYPE.TOPICIMAGE, max_length=300, verbose_name=u'脸部照片地址', default='')
    device_id = models.CharField(verbose_name=u"人脸扫描设备id", max_length=300, default="")
    create_time = models.DateTimeField(verbose_name=u'创建时间', auto_now_add=True)
    update_time = models.DateTimeField(verbose_name=u'更新时间', auto_now=True)
