# -*- coding:utf-8 -*-
'''
医生相关的用户信息
'''

from gm_types.error import ERROR as ERROR_CODES

from rpc.tool.error_code import gen
from rpc.decorators import bind_context
from hippo.models import Doctor
from api.models.activity_young_doctor import YoungDoctorRegistrationer

@bind_context('account/doctor/base_info')
def doc_info_by_uid(ctx, user_id):
    '''
    根据用户id获取医生基础信息
    '''
    try:
        _doc = Doctor.objects.get(user__id=user_id)
    except:
        return gen(ERROR_CODES.DOCTOR_NOT_FOUND)

    if not _doc.is_online:
        return gen(ERROR_CODES.DOCTOR_OFFLINE)

    result = {
        'doctor_id': _doc.id,
        'doctor_name': _doc.name,
        'doctor_portrait': _doc.portrait,
        'doctor_introduction': _doc.introduction,
        'doctor_type': _doc.doctor_type,
        'doctor_is_online': _doc.is_online,
        'doc_hospital_id': _doc.hospital_id,
    }
    result['is_entered'] = YoungDoctorRegistrationer.is_entered_by_doc_id(_doc.id)
    return result
