#!/usr/bin/env python
# coding: utf-8

from __future__ import (
    unicode_literals,
    absolute_import,
    print_function,
)

from django.db import models

from api.tool.datetime_tool import get_timestamp_or_none
# Enumeration is deprecated, reference: http://git.gengmei.cc/backend/gm-types
# from rpc.tool.enumeration import Enumeration
from rpc.tool.dict_mixin import to_dict
from gm_upload import IMG_TYPE, ImgUrlField
from gm_types.gaia import SEND_CHANNEL_TYPE
from talos.models.topic import Problem


class Article(models.Model):
    """
    NOTE:
        Desc： 主要是用于所长推荐和扒扒扒这个两个tab
    """
    COMMUNITY_TABTYPE_CHOICE = (
        ('0', u'所长说'),
        ('1', u'扒扒扒'),
    )

    class Meta:
        verbose_name = u'所长推荐/扒扒扒'
        db_table = 'community_article'
        app_label = 'community'

    title = models.CharField(max_length=128, null=False, verbose_name=u'标题')
    banner = ImgUrlField(img_type=IMG_TYPE.ARTICLE, max_length=128, null=False, verbose_name=u'bannerl')
    description = models.TextField(max_length=2000, verbose_name=u'详细描述', blank=True, default='')
    start_time = models.DateTimeField(verbose_name=u'起始时间')
    end_time = models.DateTimeField(verbose_name=u'结束时间', null=True, blank=True)
    is_online = models.BooleanField(default=True, verbose_name=u'上线')
    type = models.CharField(max_length=1, choices=COMMUNITY_TABTYPE_CHOICE, verbose_name='所长说/扒扒扒')
    topic_id = models.IntegerField(verbose_name=u"关联帖子")
    send_channel_type = models.CharField(verbose_name=u'频道', max_length=1, choices=SEND_CHANNEL_TYPE,
                                         default=SEND_CHANNEL_TYPE.OTHER)

    @property
    def topic(self):
        topic = Problem.objects.get(pk=self.topic_id)
        return topic

    def to_dict(self):
        data = to_dict(self, fields=['title', 'banner', 'is_online', 'topic_id', 'id'])
        data['topic'] = self.topic_id
        topic = self.topic
        data['topic_created_time'] = get_timestamp_or_none(topic.created_time)
        data['tags'] = topic.tag_ids
        return data
