#coding+ utf-8
from __future__ import (
    unicode_literals,
    absolute_import,
    print_function,
)

from django.utils import timezone
from django.db.models import Q

from api.models import CommunityDeploy
from community.models import (
    TopicSticky,
    Article,
)
from rpc.decorators import (
    list_interface,
    bind,
)
from talos.models.topic import Problem


@bind('api/sticky/sticky_infos')
@list_interface(offset_name='start_num', limit_name='count')
def get_sticky_infos(start_num=0, count=10, force_show=False):
    if not force_show:
        if not CommunityDeploy.get_community_deploy().get('community', False):
            return []

    sticky_info_objs = TopicSticky.objects.filter(is_online=True).order_by('ordering')
    if not sticky_info_objs:
        return []

    sticky_infos = []

    for obj in sticky_info_objs:
        if Problem.objects.filter(pk=obj.topic_id, is_online=True).first() is None:
            continue

        if len(sticky_infos) >= count:
            break

        sticky_infos.append({
                'top_id': obj.topic_id,
                'title': obj.desc
        })

    return sticky_infos
