# coding=utf-8

import xlrd
from django.core.management import BaseCommand
from api.models import Tag
from wiki.models import CollectTag, ItemTag

class Command(BaseCommand):
    """
    python manage.py insert_20180904_new_wiki_add_tags
    """

    def handle(self, *args, **options):
        data = xlrd.open_workbook('new_wiki_add_tags.xlsx'.decode('utf-8'))

        collect_table = data.sheets()[0]

        for r in range(2, collect_table.nrows):
            try:
                r_data = collect_table.row_values(r)
                collect_id = r_data[0]
                tag_id = r_data[2]
                obj = CollectTag.objects.create(collect_id=collect_id, tag_id=tag_id)
            except:
                print('collect_row=', r + 1)

        print('Collect Done!')

        item_table = data.sheets()[1]

        for r in range(2, item_table.nrows):
            try:
                r_data = item_table.row_values(r)
                item_id = r_data[0]
                tag_id = r_data[2]
                obj = ItemTag.objects.create(item_id=item_id, tag_id=tag_id)
            except:
                print('item_row=', r + 1)

        print('Item Done!')