# -*- coding: UTF-8 -*-

from django.db.models import Q, F
from api.models.service import LockList, SKULock, SkuExamineList
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from datetime import datetime


class LockListDB(DataBuilder):
    def getval_status(self, obj):
        now = datetime.now()
        if obj.start_time < now < obj.end_time:
            return u'锁定'
        else:
            return u'未锁定'

    def getval_service_id(self, obj):
        return obj.services.value_list('id', flat=True)


@DB
class LockListDQ(DataSQLQuery):
    model = LockList
    data_model = LockListDB

    def filter_start_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_end_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_service_id(self, srch_key, srch_val, regex=False):
        self.distinct = True
        return Q(services__id__contains=srch_val)

    def filter_status(self, srch_key, srch_val, regex=False):
        now = datetime.now()
        q = Q(start_time__lt=now) & Q(end_time__gt=now)
        if srch_val == '0':
            return q
        else:
            return ~q


class SKULockListDB(DataBuilder):
    def getval_status(self, obj):
        now = datetime.now()
        if obj.start_time < now < obj.end_time:
            return u'锁定'
        else:
            return u'未锁定'

    def getval_sku_id(self, obj):
        return obj.skus.value_list('id', flat=True)


class SKULockListDQ(DataSQLQuery):
    model = LockList
    data_model = LockListDB

    def filter_start_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_end_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_service_id(self, srch_key, srch_val, regex=False):
        self.distinct = True
        return Q(services__id__contains=srch_val)

    def filter_status(self, srch_key, srch_val, regex=False):
        now = datetime.now()
        q = Q(start_time__lt=now) & Q(end_time__gt=now)
        if srch_val == '0':
            return q
        else:
            return ~q

    def filter_sku_id(self, srch_key, srch_val, regex=False):
        return Q(skus__id__contains=srch_val)


class SKUUnlockDB(DataBuilder):
    def getval_service_name(self, obj):
        return obj.serviceitem.service.name

    def getval_locklist_title(self, obj):
        return obj.locklist.title


class SKUUnlockDQ(DataSQLQuery):
    model = SKULock
    data_model = SKUUnlockDB

    def filter_service_name(self, srch_key, srch_val, regex=False):
        return Q(serviceitem__service__name__contains=srch_val)

    def filter_serviceitem_id(self, srch_key, srch_val, regex=False):
        return Q(serviceitem__id__contains=srch_val)


class SkuExamineListDB(DataBuilder):
    def getval_status(self, obj):
        now = datetime.now()
        if obj.start_time < now < obj.end_time:
            return u'审核'
        else:
            return u'不审核'


@DB
class SkuExamineListDQ(DataSQLQuery):
    model = SkuExamineList
    data_model = SkuExamineListDB

    def filter_start_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_end_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)


    def filter_status(self, srch_key, srch_val, regex=False):
        now = datetime.now()
        q = Q(start_time__lt=now) & Q(end_time__gt=now)
        if srch_val == '0':
            return ~q
        else:
            return q

