# coding=utf-8
from django.db.models import Q

from api.models import ServiceRegister
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_types.gaia import SERVICE_SELL_TYPE


class PackageServiceDB(DataBuilder):
    """
    带包装列表
    """

    def getval_is_register(self, obj):
        return '新增' if obj.is_register else ('上线' if obj.service.is_online else '下线')

    def getval_last_review_time(self, obj):
        return str(obj.last_review_time).split('.')[0] if obj.last_review_time else ''

    def getval_last_submit_time(self, obj):
        return str(obj.last_submit_time).split('.')[0] if obj.last_submit_time else ''

    def getval_service_type_desc(self, obj):
        return SERVICE_SELL_TYPE.getDesc(obj.service_type)


class PackageServiceDQ(DataSQLQuery):
    """
    带包装列表
    """
    model = ServiceRegister
    data_model = PackageServiceDB

    def filter_high_com_service(self, key, value, regex=False):
        q = Q(service_type=SERVICE_SELL_TYPE.FENGXIANGGOU)
        if not int(value):
            q = ~q
        return q

    def filter_last_submit_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_last_review_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_online_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_doctor_status(self, srch_key, srch_val, regex=False):
        if srch_val == '7':
            return Q(doctor__status=7)
        else:
            return ~Q(doctor__status=7)
