# coding=utf-8
from api.models import ServiceRegister
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from django.db.models import Q
from gm_types.gaia import SERVICE_SELL_TYPE


class ServiceRegisterOfflineDB(DataBuilder):
    """
    美购待审核实体的返回数据格式
    """
    def getval_last_submit_time(self, obj):
        if obj.last_submit_time:
            return str(obj.last_submit_time)[0:19]

    def getval_service_type_desc(self, obj):
        return SERVICE_SELL_TYPE.getDesc(obj.service_type)


class ServiceRegisterOfflineDQ(DataSQLQuery):
    """
    美购待审核实体查询过滤
    """
    model = ServiceRegister
    data_model = ServiceRegisterOfflineDB

    def filter_high_com_service(self, key, value, regex=False):
        q = Q(service_type=SERVICE_SELL_TYPE.FENGXIANGGOU)
        if not int(value):
            q = ~q
        return q

    def filter_last_submit_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_doctor_status(self, srch_key, srch_val, regex=False):
        if srch_val == '7':
            return Q(doctor__status=7)
        else:
            return ~Q(doctor__status=7)
