# -*- coding: UTF-8 -*-

from django.db.models import Q
from gm_dataquery.dataquery import DataBuilder, DataSQLQuery
from gm_dataquery.db import DB
from gm_types.doctor import BUDAN_LURU_STATUS, BUDAN_LURU_TYPE

from api.models import BuDanLuRu
from api.models import SingleRecord


class SingleRecordDB(DataBuilder):
    def getval_has_tickets(self, obj):
        return True if obj.tickets_id else False


@DB
class SingleRecordDQ(DataSQLQuery):
    model = SingleRecord
    data_model = SingleRecordDB

    def filter_tickets_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_single_date(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

    def filter_has_tickets(self, srch_key, srch_val, regex=False):
        if srch_val == '1':
            return Q(tickets_id__isnull=False)
        else:
            return Q(tickets_id__isnull=True)


class BuDanLuRuDB(DataBuilder):
    def getval_month(self, obj):
        return '{}-{}'.format(str(obj.month)[0:4], str(obj.month)[-2:])

    def getval_created_time(self, obj):
        return obj.created_time.strftime('%Y-%m-%d  %H:%M:%S')

    def getval_status(self, obj):
        return BUDAN_LURU_STATUS.getDesc(obj.status)

    def getval_type(self,obj):
        return BUDAN_LURU_TYPE.getDesc(obj.type)


@DB
class BuDanLuRuDQ(DataSQLQuery):
    model = BuDanLuRu
    data_model = BuDanLuRuDB

    def filter_created_time(self, srch_key, srch_val, regex=False):
        return self._qry_time_range(srch_key, srch_val, regex)

