# coding=utf-8
# create by oldman at 2018/5/15
import math
from django.conf import settings
from django.core.management import BaseCommand

from api.models import MerchantStatDaily
from hippo.models import MerchantStatDailyData


class Command(BaseCommand):
    """
    同步数据组表的数据
    python manage.py update_2018_05_15_asyncmerchantstatdailydata
    """

    def handle(self, *args, **options):
        merchantstats = MerchantStatDaily.objects.all()
        count = merchantstats.count()
        step = 1000
        begin = 0
        rate = settings.PV_RATE
        while begin <= count:
            for merchantstat in merchantstats[begin: begin + step]:
                try:
                    merchantstatdiarydata = MerchantStatDailyData.objects.create(
                        date=merchantstat.date,
                        merchant_id=merchantstat.merchant_id,
                        ad_recharge=merchantstat.ad_recharge,
                        ad_consume=merchantstat.ad_consume,
                        offline_amount=merchantstat.offline_amount,
                        validated_price=merchantstat.validated_price,
                        validated_discount=merchantstat.validated_discount,
                        validated_price_user=merchantstat.validated_price_user,
                        rate=rate
                    )
                    merchantstatdiarydata.service_pv = int(math.ceil(merchantstat.service_pv * rate))
                    merchantstatdiarydata.home_pv = int(math.ceil(merchantstat.home_pv * rate))
                    merchantstatdiarydata.diary_pv = int(math.ceil(merchantstat.diary_pv * rate))
                    merchantstatdiarydata.save()
                except:
                    continue
            begin += step

