# coding=utf-8
# create by oldman at 2018/5/29
from django.core.management import BaseCommand

from hippo.models import Merchant
from hippo.models import MerchantBillInfo
from hippo.models.bill import DoctorFinanceInfo


class Command(BaseCommand):
    """
    同步医生的发票财务信息，结算信息到商户
    python manage.py update_2018_05_29_async_merchant_finance_info
    """

    def handle(self, *args, **options):
        merchants = Merchant.objects.filter(is_online=True)
        for merchant in merchants:
            try:
                doctorfinanceinfo = DoctorFinanceInfo.objects.get(doctor=merchant.doctor)
                merchantbillinfo, _ = MerchantBillInfo.objects.get_or_create(merchant=merchant)
                merchantbillinfo.register_address = doctorfinanceinfo.register_address
                merchantbillinfo.register_phone = doctorfinanceinfo.register_phone
                merchantbillinfo.account_name = doctorfinanceinfo.account_name
                merchantbillinfo.bank_account = doctorfinanceinfo.bank_account
                merchantbillinfo.receiver_name = doctorfinanceinfo.receiver_name
                merchantbillinfo.receiver_phone = doctorfinanceinfo.receiver_phone
                merchantbillinfo.receiver_address = doctorfinanceinfo.receiver_address
                merchantbillinfo.email = ''
                merchantbillinfo.info_type = 0
                merchantbillinfo.save()

            except Exception as e:
                print e.message
                continue
        print(u'Done')
