# coding:utf-8

from __future__ import unicode_literals

import time
from multiprocessing import Pool

from django.core.management import BaseCommand
from django.contrib.auth.models import User

from api.models.types import MESSAGE_TYPE
from message.views.message import internal_message_send


content = u'【预约赢口红！】您的国庆长假还有10天到账，凡在9.21-9.30日内预约项目、10.9日前到院验证消费的用户，均有机会获得所长随机送出的Dior口红，一共50个名额，获奖名单节就后公布！所长卖肾换来的口红，美人真不预约争取下吗？'


def send_primsg(user_id):
    internal_message_send(
        22, target_user_id=user_id,
        msg_type=MESSAGE_TYPE.TEXT,
        content=content,
    )
    print('sent to %s' % user_id)


class Command(BaseCommand):

    def handle(self, *args, **options):
        _p = Pool(4)

        start = 0
        step = 2000
        us = User.objects.all()[start:start + step]
        while len(us) > 0:
            _p.map(send_primsg, us.values_list('id', flat=True))
            time.sleep(5)

            start += step
            us = User.objects.all()[start:start + step]

        _p.close()
        _p.join()
