# coding=utf-8
from __future__ import unicode_literals, absolute_import

import json
import os
import re

from dateutil import parser as tparser
from django.conf import settings
from pytz import timezone


def tzlc(dt):
    return timezone(settings.TIME_ZONE).localize(dt.replace(microsecond=0))


def detzlc(dt_str):
    dt = tparser.parse(dt_str)
    return dt.replace(tzinfo=None)


def load_mapping(mapping_name):
    mapping_file_path = os.path.join(
        settings.BASE_DIR,
        'message', 'mapping', '%s.json' % (mapping_name,)
    )
    mapping = ''
    with open(mapping_file_path, 'r') as f:
        for line in f:
            # 去掉注释
            mapping += re.sub(r'//.*$', '', line)
    mapping = json.loads(mapping)
    return mapping
