# coding=utf-8

from django.core.management.base import NoArgsCommand
from api.models import Order
from api.models import ORDER_SOURCE
from api.models import OrderOperation
from api.models import RefundOrder
from api.models import Person
from api.models import ORDER_OPERATION_ROLE
from api.models import ORDER_OPERATION_TYPE
from api.models import REFUND_STATUS
from django.db import transaction
from django.db.models import Q
from pay.models import Wechat
from django.conf import settings


class Command(NoArgsCommand):
    def handle(self, *args, **options):
        operator = Person.objects.get(user_id=settings.BOSS)

        for refund_order in RefundOrder.objects.filter(status=REFUND_STATUS.REFUNDED):
            print refund_order.order.id,
            try:
                op = OrderOperation.objects.get(optype=ORDER_OPERATION_TYPE.REFUNDED, order=refund_order.order)
                print
            except OrderOperation.DoesNotExist:
                op = OrderOperation.objects.create(
                    order=refund_order.order,
                    operator=operator,
                    optype=ORDER_OPERATION_TYPE.REFUNDED,
                    role=ORDER_OPERATION_ROLE.SYSTEM,
                    source=refund_order.source,
                    operate_at=refund_order.refunded_at
                )
                print 'refunded_op_id %s' %op.id
