-- Deploy gaia:api_2019_08_13_add_nanshenshouge_table to mysql

BEGIN;

CREATE TABLE `api_nanshen_question` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `vector` varchar(32) NOT NULL,
    `question` varchar(512) NOT NULL,
    `choice1` varchar(512) NOT NULL,
    `type1` varchar(512) NOT NULL,
    `choice2` varchar(512) NOT NULL,
    `type2` varchar(512) NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_nanshen_answer` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `vector1` varchar(32) NOT NULL,
    `vector2` varchar(32) NOT NULL,
    `vector3` varchar(32) NOT NULL,
    `vector4` varchar(32) NOT NULL,
    `celebrity` varchar(32) NOT NULL,
    `celebrity_image` varchar(128) NOT NULL,
    `nanshen` varchar(32) NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_nanshen_report` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `vector` varchar(32) NOT NULL,
    `vector_name` varchar(32) NOT NULL,
    `vector_type` varchar(32) NOT NULL,
    `content1` varchar(2048) NOT NULL,
    `content2` varchar(2048) NOT NULL,
    `keyword` varchar(128) NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_nanshen_face_type` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `contour` varchar(30) NOT NULL,
    `chin` varchar(30) NOT NULL,
    `eyebrow` varchar(30) NOT NULL,
    `eye` varchar(30) NOT NULL,
    `nose` varchar(30) NOT NULL,
    `lip` varchar(30) NOT NULL,
    `face_type` varchar(50) NOT NULL,
    `content` varchar(2048) NOT NULL,
    `gender` varchar(1) NOT NULL,
    `celebrity` varchar(32) NOT NULL,
    `celebrity_image` varchar(80) NOT NULL,
    `nanshen` varchar(32) NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_nanshen_share_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `user_name` varchar(64) NOT NULL,
    `user_icon` varchar(64) NOT NULL,
    `content` varchar(1024) NOT NULL,
    `unlock_content` varchar(4096) NOT NULL,
    `form_id` varchar(64) NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
CREATE TABLE `api_nanshen_unlock_record` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `user_id` integer NOT NULL,
    `user_name` varchar(64) NOT NULL,
    `user_icon` varchar(256) NOT NULL,
    `unlock_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `api_nanshen_unlock_record` ADD CONSTRAINT `unlock_id_refs_id_6049fbd1` FOREIGN KEY (`unlock_id`) REFERENCES `api_nanshen_share_record` (`id`);

CREATE INDEX `api_nanshen_share_record_1ffdedc6` ON `api_nanshen_share_record` (`user_id`);
CREATE INDEX `api_nanshen_unlock_record_1ffdedc6` ON `api_nanshen_unlock_record` (`user_id`);
CREATE INDEX `api_nanshen_unlock_record_f00cf05b` ON `api_nanshen_unlock_record` (`unlock_id`);

COMMIT;
