-- Deploy gaia:doctor_2016_03_10_create_tables_for_doctor_operation_content to mysql

BEGIN;

CREATE TABLE `doctor_content` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(50) NOT NULL,
    `content` longtext NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;

CREATE TABLE `doctor_homepopup` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(50) NOT NULL,
    `image` varchar(200) NOT NULL,
    `content_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `begin_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `doctor_homepopup` ADD CONSTRAINT `content_id_refs_id_096578ce` FOREIGN KEY (`content_id`) REFERENCES `doctor_content` (`id`);

CREATE TABLE `doctor_homeslide` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(50) NOT NULL,
    `ordering` integer  NOT NULL,
    `image` varchar(200) NOT NULL,
    `content_id` integer NOT NULL,
    `is_online` bool NOT NULL,
    `begin_time` datetime(6) NOT NULL,
    `end_time` datetime(6) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `doctor_homeslide` ADD CONSTRAINT `content_id_refs_id_c2afe845` FOREIGN KEY (`content_id`) REFERENCES `doctor_content` (`id`);

CREATE TABLE `doctor_bulletin` (
    `id` integer AUTO_INCREMENT NOT NULL PRIMARY KEY,
    `title` varchar(50) NOT NULL,
    `image` varchar(200) NOT NULL,
    `content_id` integer NOT NULL,
    `is_online` bool,
    `online_time` datetime(6) NOT NULL,
    `created_time` datetime(6) NOT NULL,
    `updated_time` datetime(6) NOT NULL
)
;
ALTER TABLE `doctor_bulletin` ADD CONSTRAINT `content_id_refs_id_3dfaf2c7` FOREIGN KEY (`content_id`) REFERENCES `doctor_content` (`id`);

CREATE INDEX `doctor_homepopup_49185ad7` ON `doctor_homepopup` (`content_id`);
CREATE INDEX `doctor_homeslide_49185ad7` ON `doctor_homeslide` (`content_id`);
CREATE INDEX `doctor_bulletin_49185ad7` ON `doctor_bulletin` (`content_id`);

COMMIT;
