#!encoding=utf8

from django.core.exceptions import MultipleObjectsReturned


def add_idfv(model, platform, device_id):
    try:
        device, created = model.objects.get_or_create(platform=platform, device_id=device_id)

    except MultipleObjectsReturned:
        device = model.objects.filter(platform=platform, device_id=device_id).first()
        created = False

    return device, created
