#!/usr/bin/env python
# -*- coding:utf-8 -*-
#
#   Author  :   RobertDing
#   E-mail  :   robertdingx@gmail.com
#   Date    :   18/05/04 19:25:04
#   Desc    :   首页排序
#

from django.conf import settings
from django.db.models import Model, Manager
from django.db.models import BigIntegerField, IntegerField, FloatField


class TIDiaryScore(Model):
    class Meta:
        verbose_name = 'tidb 日记本分数'
        db_table = 'biz_feed_diary_score'

    objects = Manager().db_manager(using=settings.DB_TIDB)

    id = BigIntegerField(primary_key=True)
    diary_id = IntegerField()
    score = FloatField()
    quality_score = FloatField()
    social_score = FloatField()
    category_score = FloatField()
    profit_score = FloatField()
    update_score = FloatField()
    time_score = FloatField()
    adjust_score = FloatField()
