# coding=utf8

from __future__ import unicode_literals, absolute_import, print_function

from django.db import models

from gm_types.gaia import DIARY_CONTENT_LEVEL


class DiaryMessage(models.Model):
    """
    预设话述
    """

    class Meta:
        verbose_name = u'预设话述'
        db_table = 'api_diarymessage'
        app_label = 'talos'

    description = models.CharField(max_length=50, verbose_name='描述', default='')
    title = models.CharField(max_length=128, verbose_name='消息标题', default='')
    message = models.TextField(verbose_name=u'默认信息')
    is_delete = models.BooleanField(verbose_name=u'是否删除', default=False)
    level = models.CharField(verbose_name='日记本等级', max_length=8, choices=DIARY_CONTENT_LEVEL,
                             default=DIARY_CONTENT_LEVEL.UNAUDITED)
