# coding=utf-8

from gm_types.gaia import TOPIC_TYPE

from api import Service
from api.business.tag import TagControl
from api.models import Tag, User
from api.models.doctor import Doctor
from talos.models.topic import Problem, TopicRankingScore
from .es import tzlc
from .transfer import get_area_tag_info


def get_problem(instance):
    p = instance

    res = {
        'id':p.id,
        'diary_id': p.diary_id,
        'doctor_num':p.doctor_num,
        'created_time':tzlc(p.created_time),
        'content':p.answer,
        'is_public':p.is_public,
        'is_online':p.is_online,
        'is_elite':p.selected_qa,
        'is_sink':p.is_sink,
        'is_topic':p.is_topic,
        'pgc_category':p.pgc_classfy.id if p.pgc_classfy else None,
        'flag':p.flag,
        'topic_type':p.topic_type,
        'private_status':p.private_status,
        'title':p.ask,
        'title2':p.title,
        'channel_headline':p.channel_headline,
    }

    try:
        p.video
        res['has_video'] = True
    except Problem.video.RelatedObjectDoesNotExist:
        res['has_video'] = False

    if p.topic_type in (TOPIC_TYPE.ASK, TOPIC_TYPE.TOPIC):
        res['ranking_popularity'] = TopicRankingScore.get_pop_score(topic=p)
    else:
        res['ranking_popularity'] = 0.0

    if p.doctor_num > 0:
        res['has_doctor_reply'] = True  # 是否有医生回复
    else:
        res['has_doctor_reply'] = False

    if p.images.count() > 0:
        res['has_image'] = True  # 是否有图
    else:
        res['has_image'] = False

    if p.diary:
        if (not p.diary.is_online):
            res['is_online'] = False  # 关联日记本的帖子如果日记本下线则帖子也下线
        if p.diary.is_sink:
            res['is_sink'] = True  # 关联日记本的帖子如果日记本下沉则帖子也下沉
        if p.diary.doctor:
            if (not p.diary.doctor.is_online):
                res['is_sink'] = True
        if p.diary.service_id:
            if (not Service.objects.get(id=p.diary.service_id).is_online):
                res['is_sink'] = True

    user_info = {
        'id': p.user_id,
        'is_doctor': Doctor.objects.filter(user_id=p.user_id).exists(),
        'last_name': p.user.nickname,
    }
    if p.user_id:
        user = User.objects.get(id=p.user_id)
    else:
        user = None
    if user and hasattr(user, 'userextra') and user.userextra and user.userextra.city:
        user_info.update(get_area_tag_info(user.userextra.city))
    res['user'] = user_info

    tags = Tag.objects.filter(id__in=[pt.tag_id for pt in p.problemtag_set.all()], is_online=True)
    res['tags'] = list(set([pt.name for pt in tags]))
    res['tag_ids'] = list(set([pt.id for pt in tags]))
    closure_tags = TagControl.get_ancestors(
        initial_set=tags,
        exclude_init=False,
        is_online_only=True)
    res['closure_tag_ids'] = [t.id for t in closure_tags]

    problem_replys = p.topicreply_set.all()
    res['replys_num'] = problem_replys.count()
    res['replys'] = [{
                         'id': r.id,
                         'content': r.content,
                     } for r in problem_replys]

    last_update_time = p.last_modified
    res['last_update_time'] = tzlc(last_update_time)

    popularity = 0
    popularity += problem_replys.count()
    popularity += p.votes.count()
    res['popularity'] = popularity

    res['topic_score'] = [{
                              'user_id': ts.user.id,
                              'score': ts.score,
                          } for ts in p.topic_score.all()]

    res['topic_vote_count'] = p.vote_amount
    res['in_whitelist'] = False
    res['in_multitopic'] = False
    return res


